<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'firstname', 'email', 'password', 'birthdate', 'register_date', 'facebook_id', 'google_id', 'github_id', 'ip_address', 'last_login');
    protected $hidden = array('password');

    public function profile()
    {
        return $this->hasOne('App\Models\Profile');
    }

    public function favorites()
    {
        return $this->hasMany('App\Models\Favorite');
    }

}